DROP PROCEDURE [hips].[CountryGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 29 March 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[CountryGet] 
(
	@CountryId INT = null
)
AS
BEGIN
SELECT  c.CountryId,
		c.Code,
		c.Description,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified
		
FROM  hips.Country c
WHERE c.CountryId = @CountryId OR @CountryId IS NULL
ORDER BY c.Description asc
END
GO

